clear

a = 41.6625;
l = 166.65;
B = 75.75;

theta = -180:0.01:180;
phi = 0:20:20;

InPortH = [0.05 0.2];
ExPortH = [0.075 0.225];
x = [-180 180];

figure('Position', [200 80 1000 600])
t = tiledlayout(2,1);
t.TileSpacing = 'none';
t.Padding = 'none';

for i = 1:length(phi)

    IntakePistonPosition = (a - l + a*cos((theta-(phi(i)/2))*pi/180) + sqrt(l^2 - a^2*sin((theta-(phi(i)/2))*pi/180).^2))/(2*a);
    ExhaustPistonPosition = (a - l + a*cos((theta+(phi(i)/2))*pi/180) + sqrt(l^2 - a^2*sin((theta+(phi(i)/2))*pi/180).^2))/(2*a);
    
    IPC(i,1) = theta(find(IntakePistonPosition>InPortH(1),1));
    IPC(i,2) = theta(find(IntakePistonPosition>InPortH(2),1));
    
    EPC(i,1) = theta(find(ExhaustPistonPosition>ExPortH(1),1));
    EPC(i,2) = theta(find(ExhaustPistonPosition>ExPortH(2),1));
    
    IPO(i,1) = theta(find(IntakePistonPosition>InPortH(1),1, 'last'));
    IPO(i,2) = theta(find(IntakePistonPosition>InPortH(2),1, 'last'));
    
    EPO(i,1) = theta(find(ExhaustPistonPosition>ExPortH(1),1, 'last'));
    EPO(i,2) = theta(find(ExhaustPistonPosition>ExPortH(2),1, 'last'));

    if i == 1
        nexttile(2)
        h1 = plot(theta, ExhaustPistonPosition, 'r');
        hold on
%         plot([EPO(1) EPO(1)],[0 ExPortH(1)], 'k-.')
        plot([EPC(i,2) EPC(i,2)],[0 ExPortH(2)], 'k-.')
        plot(EPC(i,2),ExPortH(2), 'k+')
        plot([EPO(i,1) EPO(i,1)],[0 ExPortH(1)], 'k-.')
        plot(EPO(i,1),ExPortH(1), 'k+')
%         plot([EPC(2) EPC(2)],[0 ExPortH(2)], 'k-.')
        
        nexttile(1)
        h3 = plot(theta, IntakePistonPosition, 'b');
        hold on
        plot([IPC(i,1) IPC(i,1)],[0 InPortH(1)], 'k-.')
        plot(IPC(i,1),InPortH(1), 'k+')
%         plot([IPO(2) IPO(2)],[0 InPortH(2)], 'k-.')
%         plot([IPC(1) IPC(1)],[0 InPortH(1)], 'k-.')
        plot([IPO(i,2) IPO(i,2)],[0 InPortH(2)], 'k-.')
        plot(IPO(i,2),InPortH(2), 'k+')
    else
        nexttile(2)
        h2 = plot(theta, ExhaustPistonPosition, 'r--');
        plot(x,[ExPortH(1) ExPortH(1)], 'k-.')
        plot(x,[ExPortH(2) ExPortH(2)], 'k-.')
        plot([EPC(i,1) EPC(i,1)],[0 ExPortH(1)], 'k-.')
        plot(EPC(i,1),ExPortH(1), 'k+')
%         plot([EPO(2) EPO(2)],[0 ExPortH(2)], 'k-.')
%         plot([EPC(1) EPC(1)],[0 ExPortH(1)], 'k-.')
        plot([EPO(i,2) EPO(i,2)],[0 ExPortH(2)], 'k-.')
        plot(EPO(i,2),ExPortH(2), 'k+')
        hold off
        xticks([-180 EPC(2,1) EPC(1,2) 0 EPO(2,2) EPO(1,1) 180])
        xlim([-180 180])
        xtickformat('%.1f')
        ytickformat('%.1f')
        xlabel('Equivalent Crank Angle [deg]')
        ylabel({'Normalized Exhaust'; 'Piston Displacement'})
        set(gca, 'FontSize', 12)
        leg1 = ['0' char(176)];
        leg2 = ['20' char(176)];
        legend([h1 h2],{leg1 leg2});
        
        nexttile(1)
        h4 = plot(theta, IntakePistonPosition, 'b--');
        plot(x,[InPortH(1) InPortH(1)], 'k-.')
        plot(x,[InPortH(2) InPortH(2)], 'k-.')
%         plot([IPO(1) IPO(1)],[0 InPortH(1)], 'k-.')
        plot([IPC(i,2) IPC(i,2)],[0 InPortH(2)], 'k-.')
        plot(IPC(i,2),InPortH(2), 'k+')
        plot([IPO(i,1) IPO(i,1)],[0 InPortH(1)], 'k-.')
        plot(IPO(i,1),InPortH(1), 'k+')
%         plot([IPC(2) IPC(2)],[0 InPortH(2)], 'k-.')
        hold off
        xticks([-180 IPC(1,1) IPC(2,2) 0 IPO(1,2) IPO(2,1) 180])
        xlim([-180 180])
        xtickformat('%.1f')
        ytickformat('%.1f')
        xlabel('Equivalent Crank Angle [deg]')
        ylabel({'Normalized Intake'; 'Piston Displacement'})
        set(gca,'XAxisLocation','top','YAxisLocation','left','ydir','reverse')
        set(gca, 'FontSize', 12)
        legend([h3 h4],{leg1 leg2},'Location','southeast');
    end
    
end

